---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-フォームレイアウト（Bootstrap 5 水平）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全主張が根拠付き）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_5_horizontal_layout.html.twig` L1-127
- E-02: `src/Symfony/Bridge/Twig/Resources/views/Form/bootstrap_5_layout.html.twig` L1-371
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` 行51（No.50のエントリ）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行126-127（No.50の関連機能）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | bootstrap_5_layoutをuseタグで読み込む | E-01 L1 | ○ |
| C-02 | form_labelでform-floating/input-group時に除外処理 | E-01 L9-10 | ○ |
| C-03 | form_labelにcol-form-label+col-sm-2を適用 | E-01 L12-14 | ○ |
| C-04 | label=falseで空div.col-sm-2出力 | E-01 L6-7 | ○ |
| C-05 | form_label_classがcol-sm-2 | E-01 L20-22 | ○ |
| C-06 | form_row_renderで4パターンの分岐 | E-01 L26-67 | ○ |
| C-07 | form-floating水平レイアウト（空ラベル列+form-floatingネスト） | E-01 L39-43 | ○ |
| C-08 | input-group水平レイアウト（空ラベル列+input-groupネスト） | E-01 L44-50 | ○ |
| C-09 | row_classからform-floating/input-groupクラスを除去 | E-01 L34 | ○ |
| C-10 | fieldset_form_row構造 | E-01 L69-84 | ○ |
| C-11 | submit_rowでmb-3 row + 空ラベル列 + フィールド列 | E-01 L86-93 | ○ |
| C-12 | button_rowが新設 | E-01 L104-111 | ○ |
| C-13 | checkbox_rowで水平配置 | E-01 L113-122 | ○ |
| C-14 | form_group_classがcol-sm-10 | E-01 L124-126 | ○ |
| C-15 | 関連機能：Form、Twig Bridge | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 127行の小規模テンプレートで全行を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 4パターンの水平レイアウト分岐が正確か確認
- [ ] form-floating/input-groupのネスト構造が正確か確認
- [ ] グリッドクラス（col-sm-2 / col-sm-10）が正確か確認
- [ ] Bootstrap 4水平レイアウトとの差分が正確に記述されているか確認
